/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.preferences;

import com.aptana.ui.dialogfields.DialogField;
import com.aptana.ui.dialogfields.IDialogFieldListener;
import com.aptana.ui.dialogfields.SelectionButtonDialogField;
import com.aptana.ui.dialogs.ProjectSelectionDialog;
import com.aptana.ui.preferences.EplMessages;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyAndPreferenceFieldEditorPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private Control fConfigurationBlockControl;
    private ControlEnableState fBlockEnableState;
    private Link fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    private Composite fParentComposite;
    private IProject fProject;
    private Map<?, ?> fData;
    public static final String DATA_NO_LINK = "PropertyAndPreferenceFieldEditorPage.nolink";

    public PropertyAndPreferenceFieldEditorPage() {
    }

    public PropertyAndPreferenceFieldEditorPage(String title, int style) {
        super(title, style);
    }

    public PropertyAndPreferenceFieldEditorPage(int style) {
        super(style);
    }

    protected abstract boolean hasProjectSpecificOptions(IProject var1);

    protected abstract String getPreferencePageId();

    protected abstract String getPropertyPageId();

    protected boolean supportsProjectSpecificOptions() {
        return this.getPropertyPageId() != null;
    }

    protected Set<String> getNatureIDs() {
        return null;
    }

    protected boolean offerLink() {
        return this.fData == null || !Boolean.TRUE.equals(this.fData.get(DATA_NO_LINK));
    }

    protected Label createDescriptionLabel(Composite parent) {
        this.fParentComposite = parent;
        if (this.isProjectPreferencePage()) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            IDialogFieldListener listener = new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    PropertyAndPreferenceFieldEditorPage.this.enableProjectSpecificSettings(((SelectionButtonDialogField)field).isSelected());
                }
            };
            this.fUseProjectSettings = new SelectionButtonDialogField(32);
            this.fUseProjectSettings.setDialogFieldListener(listener);
            this.fUseProjectSettings.setLabelText(EplMessages.PropertyAndPreferencePage_enableProjectSpecific);
            this.fUseProjectSettings.doFillIntoGrid(composite, 1);
            PropertyAndPreferenceFieldEditorPage.setHorizontalGrabbing((Control)this.fUseProjectSettings.getSelectionButton(null));
            if (this.offerLink()) {
                this.fChangeWorkspaceSettings = this.createLink(composite, EplMessages.PropertyAndPreferencePage_workspaceSettingsLabel);
                this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            } else {
                PropertyAndPreferenceFieldEditorPage.setHorizontalSpan((Control)this.fUseProjectSettings.getSelectionButton(null), 2);
            }
            Label horizontalLine = new Label(composite, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(composite.getFont());
        } else if (this.supportsProjectSpecificOptions() && this.offerLink()) {
            this.fChangeWorkspaceSettings = this.createLink(parent, EplMessages.PropertyAndPreferencePage_projectSettingsLabel);
            this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
        return super.createDescriptionLabel(parent);
    }

    private static void setHorizontalGrabbing(Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).grabExcessHorizontalSpace = true;
        }
    }

    private static void setHorizontalSpan(Control control, int span) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalSpan = span;
        } else if (span != 1) {
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            control.setLayoutData((Object)gd);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(4, 4, true, true);
        this.fConfigurationBlockControl = super.createContents(composite);
        this.fConfigurationBlockControl.setLayoutData((Object)data);
        if (this.isProjectPreferencePage()) {
            boolean useProjectSettings = this.hasProjectSpecificOptions(this.getProject());
            this.enableProjectSpecificSettings(useProjectSettings);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyAndPreferenceFieldEditorPage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertyAndPreferenceFieldEditorPage.this.doLinkActivated((Link)e.widget);
            }
        });
        return link;
    }

    protected boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this.fUseProjectSettings != null && this.fUseProjectSettings.isSelected();
    }

    protected boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    protected void doLinkActivated(Link link) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put(DATA_NO_LINK, Boolean.TRUE);
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            HashSet<IProject> projectsWithSpecifics = new HashSet<IProject>();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject curr = projects[i];
                if (this.hasProjectSpecificOptions(curr)) {
                    projectsWithSpecifics.add(curr);
                }
                ++i;
            }
            ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), projectsWithSpecifics, this.getNatureIDs());
            if (dialog.open() == 0) {
                IProject res = (IProject)dialog.getFirstResult();
                this.openProjectProperties(res.getProject(), data);
            }
        }
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageId();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageId();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        this.fUseProjectSettings.setSelection(useProjectSpecificSettings);
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
    }

    private void updateLinkVisibility() {
        if (this.fChangeWorkspaceSettings == null || this.fChangeWorkspaceSettings.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this.fChangeWorkspaceSettings.setEnabled(!this.useProjectSettings());
        }
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fConfigurationBlockControl);
        }
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.enableProjectSpecificSettings(false);
        }
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.fProject;
    }

    public void setElement(IAdaptable element) {
        this.fProject = (IProject)element.getAdapter(IResource.class);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.fData = (Map)data;
        }
        if (this.fChangeWorkspaceSettings != null && !this.offerLink()) {
            this.fChangeWorkspaceSettings.dispose();
            this.fParentComposite.layout(true, true);
        }
    }
}

